<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

require_once 'db.php';

$response = ['status' => 'error', 'message' => ''];

try {
    // Get input data
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Invalid JSON data");
    }

    // Required fields validation
    if (empty($data['title']) || empty($data['description'])) {
        throw new Exception("Title and description are required");
    }

    // Prepare data
    $id = isset($data['id']) ? intval($data['id']) : null;
    $title = $conn->real_escape_string($data['title']);
    $category = $conn->real_escape_string($data['category'] ?? '');
    $location = $conn->real_escape_string($data['location'] ?? '');
    $description = $conn->real_escape_string($data['description']);
    $seo_title = $conn->real_escape_string($data['seotitle'] ?? '');
    $seo_description = $conn->real_escape_string($data['seodescription'] ?? '');
    
    // Handle date conversion
    $pastdate = "NULL";
    if (!empty($data['pastdate'])) {
        $dateObj = DateTime::createFromFormat('d F Y', $data['pastdate']);
        if ($dateObj) {
            $formattedDate = $dateObj->format('Y-m-d');
            $pastdate = "'" . $conn->real_escape_string($formattedDate) . "'";
        } else {
            throw new Exception("Invalid date format. Please use format like '10 April 2025'");
        }
    }

    $youtubeurl = !empty($data['youtubeurl']) ? "'".$conn->real_escape_string($data['youtubeurl'])."'" : "NULL";
    
    // Handle file uploads
    $file_paths = [];
    if (!empty($data['files']) && is_array($data['files'])) {
        if (!file_exists('uploads')) {
            mkdir('uploads', 0777, true);
        }
        
        foreach ($data['files'] as $file) {
            $filename = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9\.\-]/', '_', $file['name']);
            $filepath = "uploads/" . $filename;
        
            $fileData = base64_decode($file['data']);
            if ($fileData === false) continue;
            
            if (file_put_contents($filepath, $fileData)) {
                $file_paths[] = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/" . $filepath;
            }
        }
    }

    $files_json = !empty($file_paths) ? "'".$conn->real_escape_string(json_encode($file_paths))."'" : "NULL";

    // Start transaction
    $conn->begin_transaction();

    try {
        if ($id) {
            // UPDATE blog record
            $sql = "UPDATE blogs SET
                Blog_Title = '$title',
                Category = '$category',
                location = '$location',
                date = $pastdate,
                description = '$description',
                Youtube_link = $youtubeurl";
            
            if (!empty($file_paths)) {
                $sql .= ", Blog_image = $files_json";
            }
            
            $sql .= " WHERE blog_id = $id AND Delete_status = 0";
            
            if (!$conn->query($sql)) {
                throw new Exception("Blog update error: " . $conn->error);
            }

            $check_sql = "SELECT Blog_id FROM blog_seo WHERE Blog_id = $id";
            $exists = $conn->query($check_sql)->num_rows > 0;

            if ($exists) {
                // UPDATE existing SEO record
                $seo_sql = "UPDATE blog_seo SET 
                            Seo_title = '$seo_title',
                            Seo_description = '$seo_description'
                            WHERE Blog_id = $id";
            } else {
                // INSERT new SEO record
                $seo_sql = "INSERT INTO blog_seo (Blog_id, Seo_title, Seo_description)
                            VALUES ($id, '$seo_title', '$seo_description')";
            }

            if (!$conn->query($seo_sql)) {
                throw new Exception("SEO operation failed: " . $conn->error);
            }

            $response = [
                'status' => 'success',
                'message' => 'Blog and SEO updated successfully',
                'blog_id' => $id
            ];
        } else {
            // INSERT new blog record
            $sql = "INSERT INTO blogs (
                Blog_Title, 
                Category, 
                location,
                date, 
                description, 
                Blog_image,
                Youtube_link
            ) VALUES (
                '$title',
                '$category',
                '$location',
                $pastdate,
                '$description',
                $files_json,
                $youtubeurl
            )";

            if ($conn->query($sql)) {
                $new_id = $conn->insert_id;
                
                // Insert SEO data
                $seo_sql = "INSERT INTO blog_seo (Blog_id, Seo_title, Seo_description)
                             VALUES ($new_id, '$seo_title', '$seo_description')";
                
                if (!$conn->query($seo_sql)) {
                    throw new Exception("SEO insert error: " . $conn->error);
                }

                $response = [
                    'status' => 'success',
                    'message' => 'Blog and SEO created successfully',
                    'blog_id' => $new_id
                ];
            } else {
                throw new Exception("Blog insert error: " . $conn->error);
            }
        }

        $conn->commit();
    } catch (Exception $e) {
        $conn->rollback();
        throw $e;
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
?>